Attribute VB_Name = "mdoffsetchain"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to offset a line chain given the lineset and offsetDistance

Function offsetchain(lineSet As ObjectSet, offsetDistance As Double, offsetDirection As Long)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Dim offsetchainset As ObjectSet
Set offsetchainset = app.GetClass("ObjectSet").CreateAObjectSet

Dim chain As zLineChain
Set chain = app.GetClass("LineChain").CreateLineChain(lineSet)

Dim result As Boolean
result = False
result = offsetDirection Like 1
If (result) Then
    wantRight = False
    wantLeft = True
End If

result = False
result = offsetDirection Like 2
If (result) Then
    wantRight = True
    wantLeft = False
End If

result = False
result = offsetDirection Like 3
If (result) Then
    wantRight = True
    wantLeft = True
End If

If wantRight Then
Dim offsetLines As ObjectSet
Set offsetLines = chain.offsetLines(sketch, offsetDistance, True)
    If (offsetLines.IsEmpty()) Then
                    problem = True
    Else
    
                    'offsetchainset.AddSet offsetLines
                    Call AddSet(offsetchainset, offsetLines)
                    
    End If
End If

If wantLeft Then
chain.Reverse
Set offsetLines = chain.offsetLines(sketch, offsetDistance, True)
    If (offsetLines.IsEmpty()) Then
                    problem = True
    Else
                    offsetchainset.AddSet offsetLines
    End If
End If

Part.SetSelection offsetchainset
 
Set offsetchain = offsetchainset

End Function


Sub AddSet(destinationSet, sourceSet)

Dim it As Iterator
Set it = app.GetClass("It").CreateAObjectIt(sourceSet)
destinationSet.AddMember it.start
Do While it.IsActive
    destinationSet.AddMember it.Current
    it.Next
Loop
End Sub

